
import java.awt.geom.Ellipse2D;
import java.awt.Rectangle;

    public class Bulb extends GameObject
    {
      private int vx;
      private Ellipse2D.Float boundary;
      private boolean notLit;
      private int flashTimer;

      public Bulb(CircuitConductor cc) {
        super(cc);
        boundary = new Ellipse2D.Float((int)x,(int)y,(int)width,(int)height);
        notLit = true;
        flashTimer = 20;
        setSpriteNames(new String[] {"lightBulbOffGlow.gif",
                                     "lightBulbOnGlow1.gif",
                                     "lightBulbOnGlow2.gif"});
        setAnimationSpeed(10);
      }

      public void move()
      {
		if(notLit)
		   displayedFrame = 0;
		else if(flashTimer > 0)
		{
		   super.move();
		   flashTimer--;
	    } else
	       displayedFrame = 2;
      }

	  public boolean notLit()
	  {
		  return notLit;
	  }

      public void collision(GameObject inGameObject)
      {
		  if (inGameObject instanceof Player)
		  {
             notLit = false;
		  }
	  }

	  public void setBounds(int xPos, int yPos, int width, int height)
	  {
  		  boundary.setFrame(xPos,yPos,width,height);
      }

  	  public Rectangle getBounds()
  	  {
  		  return boundary.getBounds();
	  }
}